package com.agilex.healthcare.veteranappointment.dataservice;

import com.agilex.healthcare.veteranappointment.datalayer.appointment.AppointmentRequestInProcessDataLayer;
import com.agilex.healthcare.veteranappointment.domain.VARAppointmentRequestInProcess;

import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Component
public class AppointmentRequestInProcessDataService {
	
	@Resource
	private AppointmentRequestInProcessDataLayer appointmentRequestInProcessDataLayer;

	public VARAppointmentRequestInProcess fetchAppointmentRequestInProcessById(String appointmentRequestId) {
		return appointmentRequestInProcessDataLayer.fetchAppointmentRequestInProcessByAppointmentRequestId(appointmentRequestId);
	}

	public VARAppointmentRequestInProcess saveAppointmentRequestInProcess(VARAppointmentRequestInProcess appointmentRequestInProcess) {
		return appointmentRequestInProcessDataLayer.saveAppointmentRequestInProcess(appointmentRequestInProcess);
	}

	public void deleteAppointmentRequestInProcessById(String appointmentRequestId) {
		appointmentRequestInProcessDataLayer.deleteAppointmentRequestInProcessById(appointmentRequestId);
	}

	public void deleteAppointmentRequestInProcessByUserId(String id) {
		appointmentRequestInProcessDataLayer.deleteAppointmentRequestInProcessByUserId(id);
	}
	
}
